# Backend Switching Guide

## Quick Switch

To switch between production and local backend, edit line 12 in `scripts/background.js`:

```javascript
const DEV_CONFIG = {
    mode: 'production'  // ← CHANGE THIS LINE
};
```

## Available Modes

### 1. Production Mode (Recommended)
```javascript
mode: 'production'
```
- Uses: `https://resumescan.ai`
- Best for: Testing with real API
- No local setup needed

### 2. Local Mode
```javascript
mode: 'local'
```
- Uses: `http://localhost:3006`
- Best for: Backend development
- Requires: Local backend running

### 3. Auto Mode
```javascript
mode: 'auto'
```
- Tries: `localhost:3006` first
- Falls back to: `resumescan.ai`
- Best for: Switching between local and production automatically

## How to Use

### For Testing (Most Common)
1. Keep it on `'production'` mode
2. Load extension in Chrome
3. Test with real backend at resumescan.ai

### For Backend Development
1. Start local backend:
   ```bash
   cd resume-scanner-backend
   npm start
   ```
2. Change to `'local'` mode in background.js
3. Reload extension in Chrome

### For Auto-Switching
1. Set to `'auto'` mode
2. Extension will use local if available, otherwise production
3. No need to change config when switching

## Checking Current Backend

1. Open Chrome DevTools for the extension
2. Go to background service worker console
3. You'll see: `Backend URL: https://resumescan.ai` (or localhost)

## Note

When published to Chrome Web Store, the extension ALWAYS uses production (`https://resumescan.ai`) regardless of this setting.