// Extension Configuration
// ========================
// This file controls which backend the extension uses

const CONFIG_MODE = {
    // Choose one of these modes:
    
    // 1. PRODUCTION - Always use resumescan.ai (recommended for testing)
    // BACKEND: 'production',
    
    // 2. LOCAL - Always use localhost:3006 (for local development)
    // BACKEND: 'local',
    
    // 3. AUTO - Auto-detect: Try localhost first, fallback to production
    // BACKEND: 'auto',
    
    // Current setting:
    BACKEND: 'production'  // Change this to switch modes
};

// Backend URLs
const BACKENDS = {
    production: 'https://resumescan.ai',
    local: 'http://localhost:3006'
};

// Export for use in background.js
if (typeof module !== 'undefined' && module.exports) {
    module.exports = { CONFIG_MODE, BACKENDS };
}