from PIL import Image, ImageDraw, ImageFont
import os

def create_icon(size):
    # Create a new image with gradient background
    img = Image.new('RGBA', (size, size), (0, 0, 0, 0))
    draw = ImageDraw.Draw(img)
    
    # Draw rounded rectangle with gradient effect (simplified)
    draw.rounded_rectangle([0, 0, size, size], radius=size//6, fill=(102, 126, 234, 255))
    
    # Add text
    text = "AI"
    font_size = size // 3
    # Use default font
    draw.text((size//2, size//2), text, fill=(255, 255, 255, 255), anchor="mm")
    
    return img

# Create icons in different sizes
for size in [16, 48, 128]:
    icon = create_icon(size)
    icon.save(f'icon{size}.png')
    print(f'Created icon{size}.png')

